% Script to read data file and plot temperatures generated by
% 4x ADM1034 temp sensor ICs
% file begins with matlab timestamp
% Does comparisons between the sensors and IC's
% Used to make the data given in PDF document.

NumADMs=4;
ScanStr='%f';
iD=[];
for i=1:NumADMs
    ScanStr=[ScanStr,',%2X%2X%2X%2X%2X%2X%2X'];
    iD=[iD,3+(i-1)*7:8+(i-1)*7];
end
fid=fopen('capture6.txt','r');
d=fscanf(fid,ScanStr,[1+(7*NumADMs),inf]);  %All 3 sensors being output
fclose(fid);
DT=d(1,:); 
DT1=DT(1);
DT=DT-DT1;

%D=d([3:8,10:15],:)';
D=d(iD,:)';

Temp=@(MSB,LSB)(MSB-64)+bitand(248,LSB)/256; %Convert 2 bytes to temperature
%TempErrorN=@(N) -mod(N-1,3); %this is the fixed error term between channels....
%TempErrorN=@(N) 0;
TempN=@(N)Temp(D(:,(N-1)*2+2),D(:,(N-1)*2+1)); %Convert Sensor N in data array to temperature

% work out the systematic offset between internal and external sensors
a1=stats(TempN(1)-TempN(2))
a2=stats(TempN(4)-TempN(5))
b1=stats(TempN(2)-TempN(3))
b2=stats(TempN(5)-TempN(6))

c1=stats(TempN(2)-TempN(5))
c2=stats(TempN(3)-TempN(6))

%plot it
close all;
colors='rgbycmrgbycmrgbycmrgbycm';
colors='rgbrgbrgbrgbrgbrgbrgbrgb';
figure
for i=1:NumADMs*3
  plot(DT,TempN(i),colors(i)); 
  hold on;
end
% plot(DT,TempN(2),'g');
% plot(DT,TempN(3),'b');
% plot(DT,TempN(4),'y');
% plot(DT,TempN(5),'c');
% plot(DT,TempN(6),'m');
line2('x',T0,'color','k');

legend('#1 Int','#1 Ext1','#1 Ext2','#2 Int','#2 Ext1','#2 Ext2', '#3 Int','#3 Ext1','#3 Ext2','#4 Int','#4 Ext1','#4 Ext2',[num2str(T0),'C']);

plotdatetime(DT1); %put a date/time axis on graph
title('Raw temperature data');
%-------------------------------------------------------------
[B,A]=butter(4,0.1,'high');
noiseN=@(N)std(filter(B,A,TempN(N)));


for i=1:NumADMs
    m=(i-1)*3+1
   dT0(i)=mean(TempN(m)-T0); 
   dT1(i)=mean(TempN(m)-TempN(m+1));
   dT2(i)=mean(TempN(m+1)-TempN(m+2));
end
dT0
dT1
dT2

%-------------------------------------------------------------
FirstChannel=@(N) (floor((N-1)./3)*3+1); %returns index to the first channel of this device
TempErrorN=@(N) -mod(N-1,3); %this is the fixed error term between channels....
%TempErrorN=@(N) (TempN(N) - TempN(FirstChannel(N)+2));
%TempErrorN=@(N) 0;
%TempCorrectedN=@(N) (TempN(N) - TempN(FirstChannel(N)+2) -TempErrorN(N) -2 ); % -T0; %Convert Sensor N in data array to temperature
TempCorrectedN=@(N) (TempN(N) - TempN(FirstChannel(N)) -TempErrorN(N) ); % -T0; %Convert Sensor N in data array to temperature

figure
for i=1:NumADMs*3
    T=TempCorrectedN(i);
    mean(T)
  plot(DT,T,colors(i)); 
  hold on;
end
%line2('x',0,'color','k');

legend('#1 Int','#1 Ext1','#1 Ext2','#2 Int','#2 Ext1','#2 Ext2', ...
    '#3 Int','#3 Ext1','#3 Ext2','#4 Int','#4 Ext1','#4 Ext2');%, ...
%    [num2str(T0),'C']);

plotdatetime(DT1); %put a date/time axis on graph
%title('Corrected Temperature Data: 1C per channel error removed')
title('Temperature normalised to Ext2 for each IC')
%show noise stats

for i=1:NumADMs
    m=(i-1)*3+1
   dT0(i)=mean(TempCorrectedN(m)); 
   dT1(i)=mean(TempCorrectedN(m+1));
   dT2(i)=mean(TempCorrectedN(m+2));
end
dT0
dT1
dT2
mean(dT0),mean(dT1),mean(dT2)
%show noise stats
%stats(diff(TempN(1)))
%stats(diff(TempN(2)))
%stats(diff(TempN(3)))
Noise=[];
for i=1:NumADMs*3
    Noise=[Noise,noiseN(i)];
end
