% Script to read data file and plot temperatures generated by a single
% ADM1034 temp sensor IC
% file begins with matlab timestamp
% This file does not adjust values for the systematic errors described in 
% the pdf document.

fid=fopen('LogData.dat','r');
d=fscanf(fid,'%f,%2X%2X%2X%2X%2X%2X%2X',[8,inf]);  %All 3 sensors being output
fclose(fid);
DT=d(1,:); 
DT1=DT(1);
DT=DT-DT1;

D=d(3:8,:)';

Temp=@(MSB,LSB)(MSB-64)+bitand(248,LSB)/256; %function to Convert 2 bytes to temperature
TempN=@(Offset)Temp(D(:,(Offset-1)*2+2),D(:,(Offset-1)*2+1)); %function to Convert Sensor N in data array to temperature

close all;
figure
subplot(1,2,1);
plot(DT,TempN(1),'r'); 
hold on; 
plot(DT,TempN(2),'g');
plot(DT,TempN(3),'b');

plotdatetime(DT1); %put a date/time axis on graph
title('Unadjusted Temperature readings from a single ADM1034')
legend('Internal','Ext 1','Ext 2');

subplot(1,2,2);
plot(DT,TempN(1),'r'); 
hold on; 
plot(DT,TempN(2)+1,'g');
plot(DT,TempN(3)+2,'b');

plotdatetime(DT1); %put a date/time axis on graph
title('Corrected readings from a single ADM1034')
legend('Internal','Ext 1 + 1\circC','Ext 2 + 2\circC');

% work out the systematic offset between internal and external sensors
a=mean(TempN(1)-TempN(2))
b=mean(TempN(1)-TempN(3))
Offset=(a+b)/2;

%show noise stats
stats(diff(TempN(1)))
stats(diff(TempN(2)))
stats(diff(TempN(3)))