function PlotDateTime(StartDateNum,EndDateNum)
% PlotDateTime([StartDateNum,EndDateNum]) Plot times/dates on time series graphs in vertical text
% Plots time every hour, and date at midnight and first position...
% Only puts about 24 marks max on each plot. Marks always fall on midnight
% extended to work for short intervals and label them usefully with date and time
% draws on the current axis....
% Examples
% PlotDateTime() assumes that xaxis is a valid datenum
% PlotDateTime(DateNums) Datenums is a vector of datenums
% PlotDateTime(StartDateNum) assumes xaxis is in days from 0
% PlotDateNum(StartDateNum,EndDateNum) assumes scale is not in days 
% PlotDateNum('SelfTest') runs the demo
%
% sets an appropriate default xlabel if it can work it out from the time units on the axis:
% time, date, days, hours, mins ,secs  (doesn't override label that is on the plot)
% ie if 
% for very short periods forces times with seconds onto plot
%
% You should use "axis tight"  for annotations to align correctly

%see also: Genplot, dateaxis datestr datenum now

%SJB $Revision: 1174 $ $Date: 2008-02-25 12:14:19 +1300 (Mon, 25 Feb 2008) $

TextRotateAngle=90;
hax=gca;
xlim=get(hax,'xlim');
RawTimeAxis=0;
switch nargin 
  case 0; % must be plotted in datenum units (ie days)
         StartDateNum=xlim(1);
         EndDateNum=xlim(2);
         StartX=xlim(1); XScale=1;
         RawTimeAxis=1;
  case 1,  
         if ischar(StartDateNum)
           switch lower(StartDateNum)
             case {'selftest','demo'}, plotdatetime_SelfTest; return;
               otherwise, error(['unknown parameter :',StartDateNum]);
             end; %switch 
          elseif length(StartDateNum)>1 %must be a vector of times
             EndDateNum=StartDateNum(end);
             StartDateNum=StartDateNum(1);
             StartX=xlim(1); 
             XScale= (EndDateNum-StartDateNum) / (xlim(2)-xlim(1));
          else %must be a single number  
             % xaxis must be in Days from StartDateNum
             EndDateNum=xlim(2)+StartDateNum;
             StartDateNum=xlim(1)+StartDateNum;
             StartX=xlim(1); XScale=1;
        end;%if
  
       
  case 2, StartX=xlim(1); 
     XScale= (EndDateNum-StartDateNum) / (xlim(2)-xlim(1));
  otherwise
    error('wrong number of arguments');
end; %switch
% Change text formats here.....
DateFormat=1;
TimeFormat=16;      %16 'HH:MM PM' 3:45 PM    
%TimeFormat=15;      %16 'HH:MM' 15:45    
RawTimeAxis=StartDateNum==StartX;  %this will only work if axis is tight

ax=axis;  %get current axis extent
YPos=ax(4) - (ax(4)-ax(3))/3;

%StartDateNum=Times(1)
%EndDateNum=Times(length(Times))

% number of 1 hour marks to plot...
NHrs=24*( (floor(EndDateNum*24)/24)-(ceil(StartDateNum*24)/24) );
%NHrs=NHrs;

HrsPerMark=ceil(1/24*NHrs);

% now ensure that only about 24 marks per graph max, and that marks will fall on Hr00
switch HrsPerMark
case 0 
    HrsPerMark=1;
    NHrs=24*( (floor(EndDateNum*(24*60))/(24*60))-(ceil(StartDateNum*(24*60))/(24*60)) );
    if NHrs<=0
       NHrs=24*(EndDateNum-StartDateNum);
    end;   
    HrsPerMark=RoundMinutesMarks(NHrs);
    if HrsPerMark< 1/60
       TimeFormat=13; %13  'HH:MM:SS' 15:45:17
    end;
  case 5
    HrsPerMark=6;
  case 7
    HrsPerMark=8;
  case {9,10,11,13,14}
    HrsPerMark=12;
  otherwise
    HrsPerMark=ceil(HrsPerMark);
    if HrsPerMark>=15
      HrsPerMark=ceil(HrsPerMark/24)*24;
    end;
end; %switch
MPD=24/HrsPerMark;  %MarksPerDay

% At last write them on the graph
% every hour print the time, every day print the date....
first=1;
TickDateNums=(ceil(StartDateNum*MPD)/MPD) :(1/MPD) : (floor(EndDateNum*MPD)/MPD);

%this block should be obsolete now, but leave it in anyway
if isempty(TickDateNums) | length(TickDateNums)<=1 %very short periods
    warning('Assert:This line should not run any more if RoundMinuteMarks is working');
    TimeSpan=EndDateNum-StartDateNum;
    if TimeSpan<1/24
        TimeFormat=13; %13  'HH:MM:SS' 15:45:17
    end;%if
    TickDateNums=StartDateNum+ (TimeSpan*[0.05,.1:.2:.9]);
end;%if
%datestr(TickDateNums)

for DN= TickDateNums
  if (mod(DN,1)< 0.5/MPD) | first %if hour=0  or first one...
      S=datestr(DN,1);         %show date
    else
      S=datestr(DN,TimeFormat);        %else show time
    end;
  t1=text((DN-StartDateNum)/XScale +xlim(1),YPos,S);
  set(t1,'rotation',TextRotateAngle,'fontsize',6,'fontweight','bold');
  first=0; %clear flag
end; %for

%now we try to set the xlabel string if it hasn't been set already...
hXLabel=get(hax,'XLabel');
XLabelStr=get(hXLabel,'String');
if isempty(XLabelStr)
   
if RawTimeAxis %x axis is in matlab time units
    set(hax,'xtickmode','manual','xtick',TickDateNums ,'xticklabel',{});
    if NHrs<24
        xlabel('time');
      else
        xlabel('date');
    end;%if
  else
  %XScale=XScale
  %round(XScale*24*3600)
    switch round(XScale*24*3600)
      case 24*3600, xlabel('days');
      case 3600, xlabel('hours')
      case 60, xlabel('mins')
      case 1, xlabel('secs')
      otherwise
    end; %switch
 end;%if
end; %Label Xaxis if possible

%dateaxis('x',0,0);

function [HrsPerMark]=RoundMinutesMarks(NHrs)
% RoundMinsPerMark
%
% see also:

% 12:34AM 07/03/2004 SJB 
 NominalNumTicks=5;
 MinsPerMark = NHrs*60/NominalNumTicks;
 if MinsPerMark >= 1
     MinsPerMark=Round60(MinsPerMark);
   else %must be down into secs
     SecsPerMark=Round60(MinsPerMark*60);
     if SecsPerMark>=1
         MinsPerMark=SecsPerMark/60;
       else
         %minspermark is already correct
     end;%if
 end;
 HrsPerMark=MinsPerMark/60;

 function [N]=Round60(N)
 % Round60(N) Does logical rounding of numbers as whole parts of 60.
 % -ve numbers work correctly
 %
 % see also:

% 1:25AM 07/03/2004 SJB 
 V=abs(N);
 if V >= 60
   V=60;
 elseif V >=30
   V=30;
 elseif V >=30
   V=30;
 elseif V >=20
   V=20;
 elseif V >=15
    V=15;
 %elseif V >=12
 %   V=12;
 elseif V >=10
   V=10;
 elseif V >=5
   V=5;
 elseif V >=2
   V=2;
 elseif V >=1
   V=1;
 else 
   %return V unchanged
end;
N=V*sign(N); 
%<begin SelfTest>--------------------------------------------------
function plotdatetime_SelfTest
%
%dbstop if error; %so you can inspect vars when it crashes
fprintf(1,'\n--------------Testing plotdatetime: Tests that should work  --------------------\n');
HR=1/(24);
MIN=1/(24*60);
SEC=1/(24*3600);
%figure
subplot(2,3,1);
q=(0:0.15:3);
plot(now+q,q,'r');
axis tight;
plotdatetime;
subplot(2,3,2);
plot(q,-q,'g');
axis tight;
plotdatetime(now);

q=(-0.1:1:57);
subplot(2,3,3);
plot(q,q,'b');
axis tight;
xlabel('Explicitly set Minute')
plotdatetime(now,now+(57*MIN));

subplot(2,3,4);
plot(q,q,'b');
axis tight;
%xlabel('')
qdatenums=(q*MIN)+now;
plotdatetime(qdatenums);

subplot(2,3,4);
plot(q,q,'b');
axis tight;
qdatenums=(q*SEC)+now;
plotdatetime(qdatenums);

%now demo the auto setting of the xlabel, and short span display
figure
q=(-0.1:1:100);
subplot(2,2,1);
plot(q,q,'r');
axis tight;
plotdatetime(now,now+(100));

subplot(2,2,2);
plot(q,q,'g');
axis tight;
plotdatetime(now,now+(100*HR));

subplot(2,2,3);
plot(q,q,'b');
axis tight;
plotdatetime(now,now+(100*MIN));

subplot(2,2,4);
plot(q,-q,'m');
axis tight;
plotdatetime(now,now+(100*SEC));

%if
%  warning('failed trying to  at(1)');
%  keyboard;
%end;%if
%fprintf(1,'\n-------------- Tests that SHOULD throw errors  --------------------\n');
%try

%  warning('failed with invalid state number 4');
%  keyboard;
%catch
%  fprintf(1,[lasterr,'\n^Should have errored: \n']);
%end; %try

fprintf(1,['-------- Seems to have worked OK',' -----------\n']);
